/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.serialization;

import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.insulation.StaticInsulation;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.type.Insulator;
import com.momosoftworks.coldsweat.config.type.PredicateItem;
import com.momosoftworks.coldsweat.data.codec.requirement.EntityRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.ItemRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.util.AttributeModifierMap;
import com.momosoftworks.coldsweat.util.exceptions.ArgumentCountException;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMultiMap;
import com.momosoftworks.coldsweat.util.serialization.DynamicHolder;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.tags.ITag;
import oshi.util.tuples.Triplet;

public class ConfigHelper {
    private ConfigHelper() {
    }

    public static <T> List<T> parseRegistryItems(ResourceKey<Registry<T>> registry, RegistryAccess registryAccess, String objects) {
        ArrayList<Object> biomeList = new ArrayList<Object>();
        Registry reg = registryAccess.m_175515_(registry);
        if (reg == null) {
            return biomeList;
        }
        for (String objString : objects.split(",")) {
            if (objString.startsWith("#")) {
                String tagID = objString.replace("#", "");
                Optional tag = reg.m_203431_(TagKey.m_203882_(registry, (ResourceLocation)new ResourceLocation(tagID)));
                tag.ifPresent(tg -> biomeList.addAll(tg.m_203614_().map(Holder::m_203334_).toList()));
                continue;
            }
            ResourceLocation id = new ResourceLocation(objString);
            Optional<Object> obj = Optional.ofNullable(reg.m_7745_(id));
            if (obj.isEmpty()) {
                ColdSweat.LOGGER.error("Error parsing config: \"{}\" does not exist", (Object)objString);
                continue;
            }
            biomeList.add(obj.get());
        }
        return biomeList;
    }

    public static List<Block> getBlocks(String ... ids) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (String id : ids) {
            if (id.startsWith("#")) {
                String tagID = id.replace("#", "");
                CSMath.doIfNotNull(ForgeRegistries.BLOCKS.tags(), tags -> {
                    Optional<ITag> optionalTag = tags.stream().filter(tag -> tag.getKey() != null && tag.getKey().f_203868_().toString().equals(tagID)).findFirst();
                    optionalTag.ifPresent(blockITag -> blocks.addAll(blockITag.stream().toList()));
                });
                continue;
            }
            ResourceLocation blockId = new ResourceLocation(id);
            if (ForgeRegistries.BLOCKS.containsKey(blockId)) {
                blocks.add((Block)ForgeRegistries.BLOCKS.getValue(blockId));
                continue;
            }
            ColdSweat.LOGGER.error("Error parsing block config: block \"{}\" does not exist", (Object)id);
        }
        return blocks;
    }

    public static List<Item> getItems(String ... ids) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (String itemId : ids) {
            if (itemId.startsWith("#")) {
                String tagID = itemId.replace("#", "");
                CSMath.doIfNotNull(ForgeRegistries.ITEMS.tags(), tags -> {
                    Optional<ITag> optionalTag = tags.stream().filter(tag -> tag.getKey() != null && tag.getKey().f_203868_().toString().equals(tagID)).findFirst();
                    optionalTag.ifPresent(itemITag -> items.addAll(itemITag.stream().toList()));
                });
                continue;
            }
            ResourceLocation itemID = new ResourceLocation(itemId);
            if (ForgeRegistries.ITEMS.containsKey(itemID)) {
                items.add((Item)ForgeRegistries.ITEMS.getValue(itemID));
                continue;
            }
            ColdSweat.LOGGER.error("Error parsing item config: item \"{}\" does not exist", (Object)itemId);
        }
        return items;
    }

    public static Map<Biome, Triplet<Double, Double, Temperature.Units>> getBiomesWithValues(List<? extends List<?>> source, boolean absolute, RegistryAccess registryAccess) {
        HashMap<Biome, Triplet<Double, Double, Temperature.Units>> map = new HashMap<Biome, Triplet<Double, Double, Temperature.Units>>();
        for (List<?> entry : source) {
            try {
                String biomeIdString = (String)entry.get(0);
                for (Biome biome : ConfigHelper.parseRegistryItems(Registry.f_122885_, registryAccess, biomeIdString)) {
                    double max;
                    double min;
                    Temperature.Units units;
                    if (biome == null) {
                        ColdSweat.LOGGER.error("Error parsing biome config: string \"{}\" contains a biome that does not exist or is not loaded yet", (Object)biomeIdString);
                        continue;
                    }
                    if (entry.size() > 2) {
                        units = entry.size() == 4 ? Temperature.Units.valueOf(((String)entry.get(3)).toUpperCase()) : Temperature.Units.MC;
                        min = Temperature.convert(((Number)entry.get(1)).doubleValue(), units, Temperature.Units.MC, absolute);
                        max = Temperature.convert(((Number)entry.get(2)).doubleValue(), units, Temperature.Units.MC, absolute);
                    } else {
                        double mid = ((Number)entry.get(1)).doubleValue();
                        double variance = 1.0f / Math.max(1.0f, 2.0f + biome.m_47548_() * 2.0f);
                        min = mid - variance;
                        max = mid + variance;
                        units = Temperature.Units.MC;
                    }
                    map.put(biome, (Triplet<Double, Double, Temperature.Units>)new Triplet((Object)min, (Object)max, (Object)units));
                }
            }
            catch (Exception e) {
                ColdSweat.LOGGER.error("Error parsing biome config \"{}\"", (Object)entry.toString());
                e.printStackTrace();
            }
        }
        return map;
    }

    public static Map<DimensionType, Pair<Double, Temperature.Units>> getDimensionsWithValues(List<? extends List<?>> source, boolean absolute, RegistryAccess registryAccess) {
        HashMap<DimensionType, Pair<Double, Temperature.Units>> map = new HashMap<DimensionType, Pair<Double, Temperature.Units>>();
        for (List<?> entry : source) {
            try {
                String dimensionIdString = (String)entry.get(0);
                for (DimensionType dimension : ConfigHelper.parseRegistryItems(Registry.f_122818_, registryAccess, dimensionIdString)) {
                    if (dimension == null) {
                        ColdSweat.LOGGER.error("Error parsing dimension config: string \"{}\" contains a dimension that does not exist or is not loaded yet", (Object)dimensionIdString);
                        continue;
                    }
                    double temp = ((Number)entry.get(1)).doubleValue();
                    Temperature.Units units = entry.size() == 3 ? Temperature.Units.valueOf(((String)entry.get(2)).toUpperCase()) : Temperature.Units.MC;
                    map.put(dimension, (Pair<Double, Temperature.Units>)Pair.of((Object)Temperature.convert(temp, units, Temperature.Units.MC, absolute), (Object)((Object)units)));
                }
            }
            catch (Exception e) {
                ColdSweat.LOGGER.error("Error parsing dimension config \"{}\"", (Object)entry.toString());
                e.printStackTrace();
            }
        }
        return map;
    }

    public static Map<StructureType<?>, Pair<Double, Temperature.Units>> getStructuresWithValues(List<? extends List<?>> source, boolean absolute, RegistryAccess registryAccess) {
        HashMap map = new HashMap();
        for (List<?> entry : source) {
            try {
                String structureIdString = (String)entry.get(0);
                for (Structure structure : ConfigHelper.parseRegistryItems(Registry.f_235725_, registryAccess, structureIdString)) {
                    if (structure == null) {
                        ColdSweat.LOGGER.error("Error parsing structure config: string \"{}\" contains a structure that does not exist or is not loaded yet", (Object)structureIdString);
                        continue;
                    }
                    double temp = ((Number)entry.get(1)).doubleValue();
                    Temperature.Units units = entry.size() == 3 ? Temperature.Units.valueOf(((String)entry.get(2)).toUpperCase()) : Temperature.Units.MC;
                    map.put(structure.m_213658_(), (Pair<Double, Temperature.Units>)Pair.of((Object)Temperature.convert(temp, units, Temperature.Units.MC, absolute), (Object)((Object)units)));
                }
            }
            catch (Exception e) {
                ColdSweat.LOGGER.error("Error parsing structure config \"{}\"", (Object)entry.toString());
                e.printStackTrace();
            }
        }
        return map;
    }

    public static Map<String, Predicate<BlockState>> getBlockStatePredicates(Block block, String predicates) {
        String[] predicateList;
        HashMap<String, Predicate<BlockState>> blockPredicates = new HashMap<String, Predicate<BlockState>>();
        for (String predicate : predicateList = predicates.split(",")) {
            String[] pair = predicate.split("=");
            String key = pair[0];
            String value = pair[1];
            Property property = block.m_49965_().m_61081_(key);
            if (property == null) continue;
            property.m_6215_(value).ifPresent(propertyValue -> blockPredicates.put(predicate, state -> state.m_61143_(property).equals(propertyValue)));
        }
        return blockPredicates;
    }

    public static List<EntityType<?>> getEntityTypes(String ... entities) {
        ArrayList entityList = new ArrayList();
        for (String entity : entities) {
            if (entity.startsWith("#")) {
                String tagID = entity.replace("#", "");
                CSMath.doIfNotNull(ForgeRegistries.ENTITY_TYPES.tags(), tags -> {
                    Optional<ITag> optionalTag = tags.stream().filter(tag -> tag.getKey() != null && tag.getKey().f_203868_().toString().equals(tagID)).findFirst();
                    optionalTag.ifPresent(entityITag -> entityList.addAll(entityITag.stream().toList()));
                });
                continue;
            }
            ResourceLocation entityId = new ResourceLocation(entity);
            if (ForgeRegistries.ENTITY_TYPES.containsKey(entityId)) {
                entityList.add((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId));
                continue;
            }
            ColdSweat.LOGGER.error("Error parsing entity config: entity \"{}\" does not exist", (Object)entity);
        }
        return entityList;
    }

    public static CompoundTag serializeNbtBool(boolean value, String key) {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_(key, value);
        return tag;
    }

    public static CompoundTag serializeNbtInt(int value, String key) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(key, value);
        return tag;
    }

    public static CompoundTag serializeNbtDouble(double value, String key) {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_(key, value);
        return tag;
    }

    public static CompoundTag serializeNbtString(String value, String key) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(key, value);
        return tag;
    }

    public static CompoundTag serializeBiomeTemps(Map<Biome, Triplet<Double, Double, Temperature.Units>> map, String key, RegistryAccess registryAccess) {
        CompoundTag tag = new CompoundTag();
        CompoundTag mapTag = new CompoundTag();
        for (Map.Entry<Biome, Triplet<Double, Double, Temperature.Units>> entry : map.entrySet()) {
            CompoundTag biomeTag = new CompoundTag();
            ResourceLocation biomeId = RegistryHelper.getBiomeId(entry.getKey(), registryAccess);
            if (biomeId == null) {
                ColdSweat.LOGGER.error("Error serializing biome temperatures: biome \"{}\" does not exist", (Object)entry.getKey());
                continue;
            }
            biomeTag.m_128347_("Min", ((Double)entry.getValue().getA()).doubleValue());
            biomeTag.m_128347_("Max", ((Double)entry.getValue().getB()).doubleValue());
            biomeTag.m_128359_("Units", ((Temperature.Units)((Object)entry.getValue().getC())).toString());
            mapTag.m_128365_(biomeId.toString(), (Tag)biomeTag);
        }
        tag.m_128365_(key, (Tag)mapTag);
        return tag;
    }

    public static Map<Biome, Triplet<Double, Double, Temperature.Units>> deserializeBiomeTemps(CompoundTag tag, String key, RegistryAccess registryAccess) {
        HashMap<Biome, Triplet<Double, Double, Temperature.Units>> map = new HashMap<Biome, Triplet<Double, Double, Temperature.Units>>();
        CompoundTag mapTag = tag.m_128469_(key);
        for (String biomeID : mapTag.m_128431_()) {
            CompoundTag biomeTag = mapTag.m_128469_(biomeID);
            Biome biome = RegistryHelper.getBiome(new ResourceLocation(biomeID), registryAccess);
            if (biome == null) {
                ColdSweat.LOGGER.error("Error deserializing biome temperatures: biome \"{}\" does not exist", (Object)biomeID);
                continue;
            }
            map.put(biome, (Triplet<Double, Double, Temperature.Units>)new Triplet((Object)biomeTag.m_128459_("Min"), (Object)biomeTag.m_128459_("Max"), (Object)Temperature.Units.valueOf(biomeTag.m_128461_("Units"))));
        }
        return map;
    }

    public static CompoundTag serializeDimensionTemps(Map<DimensionType, Pair<Double, Temperature.Units>> map, String key, RegistryAccess registryAccess) {
        CompoundTag tag = new CompoundTag();
        CompoundTag mapTag = new CompoundTag();
        for (Map.Entry<DimensionType, Pair<Double, Temperature.Units>> entry : map.entrySet()) {
            CompoundTag dimensionTag = new CompoundTag();
            ResourceLocation dimensionId = RegistryHelper.getDimensionId(entry.getKey(), registryAccess);
            if (dimensionId == null) {
                ColdSweat.LOGGER.error("Error serializing dimension temperatures: dimension \"{}\" does not exist", (Object)entry.getKey());
                continue;
            }
            mapTag.m_128365_(dimensionId.toString(), (Tag)dimensionTag);
            dimensionTag.m_128347_("Temp", ((Double)entry.getValue().getFirst()).doubleValue());
            dimensionTag.m_128359_("Units", ((Temperature.Units)((Object)entry.getValue().getSecond())).toString());
            mapTag.m_128365_(dimensionId.toString(), (Tag)dimensionTag);
        }
        tag.m_128365_(key, (Tag)mapTag);
        return tag;
    }

    public static Map<DimensionType, Pair<Double, Temperature.Units>> deserializeDimensionTemps(CompoundTag tag, String key, RegistryAccess registryAccess) {
        HashMap<DimensionType, Pair<Double, Temperature.Units>> map = new HashMap<DimensionType, Pair<Double, Temperature.Units>>();
        CompoundTag mapTag = tag.m_128469_(key);
        for (String dimensionId : mapTag.m_128431_()) {
            CompoundTag biomeTag = mapTag.m_128469_(dimensionId);
            DimensionType dimension = RegistryHelper.getDimension(new ResourceLocation(dimensionId), registryAccess);
            if (dimension == null) {
                ColdSweat.LOGGER.error("Error deserializing dimension temperatures: dimension \"{}\" does not exist", (Object)dimensionId);
                continue;
            }
            map.put(dimension, (Pair<Double, Temperature.Units>)Pair.of((Object)biomeTag.m_128459_("Temp"), (Object)((Object)Temperature.Units.valueOf(biomeTag.m_128461_("Units")))));
        }
        return map;
    }

    public static CompoundTag serializeStructureTemps(Map<StructureType<?>, Pair<Double, Temperature.Units>> map, String key, RegistryAccess registryAccess) {
        CompoundTag tag = new CompoundTag();
        CompoundTag mapTag = new CompoundTag();
        for (Map.Entry<StructureType<?>, Pair<Double, Temperature.Units>> entry : map.entrySet()) {
            CompoundTag structureTag = new CompoundTag();
            ResourceLocation structureId = RegistryHelper.getStructureId(entry.getKey(), registryAccess);
            if (structureId == null) {
                ColdSweat.LOGGER.error("Error serializing structure temperatures: structure \"{}\" does not exist", entry.getKey());
                continue;
            }
            mapTag.m_128365_(structureId.toString(), (Tag)structureTag);
            structureTag.m_128347_("Temp", ((Double)entry.getValue().getFirst()).doubleValue());
            structureTag.m_128359_("Units", ((Temperature.Units)((Object)entry.getValue().getSecond())).toString());
            mapTag.m_128365_(structureId.toString(), (Tag)structureTag);
        }
        tag.m_128365_(key, (Tag)mapTag);
        return tag;
    }

    public static Map<StructureType<?>, Pair<Double, Temperature.Units>> deserializeStructureTemps(CompoundTag tag, String key, RegistryAccess registryAccess) {
        HashMap map = new HashMap();
        CompoundTag mapTag = tag.m_128469_(key);
        for (String structureId : mapTag.m_128431_()) {
            CompoundTag biomeTag = mapTag.m_128469_(structureId);
            StructureType<?> structure = RegistryHelper.getStructure(new ResourceLocation(structureId), registryAccess);
            if (structure == null) {
                ColdSweat.LOGGER.error("Error deserializing structure temperatures: structure \"{}\" does not exist", (Object)structureId);
                continue;
            }
            map.put(structure, (Pair<Double, Temperature.Units>)Pair.of((Object)biomeTag.m_128459_("Temp"), (Object)((Object)Temperature.Units.valueOf(biomeTag.m_128461_("Units")))));
        }
        return map;
    }

    public static <T> CompoundTag serializeItemMap(Map<Item, T> map, String key, Function<T, CompoundTag> serializer) {
        CompoundTag tag = new CompoundTag();
        CompoundTag mapTag = new CompoundTag();
        for (Map.Entry<Item, T> entry : map.entrySet()) {
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)entry.getKey());
            if (itemId == null) {
                ColdSweat.LOGGER.error("Error serializing item map: item \"{}\" does not exist", (Object)entry.getKey());
                continue;
            }
            mapTag.m_128365_(itemId.toString(), (Tag)serializer.apply(entry.getValue()));
        }
        tag.m_128365_(key, (Tag)mapTag);
        return tag;
    }

    public static <T> CompoundTag serializeItemMultimap(Multimap<Item, T> map, String key, Function<T, CompoundTag> serializer) {
        CompoundTag tag = new CompoundTag();
        ListTag mapTag = new ListTag();
        for (Map.Entry entry : map.entries()) {
            CompoundTag entryTag = new CompoundTag();
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)((Item)entry.getKey()));
            if (itemId == null) {
                ColdSweat.LOGGER.error("Error serializing item map: item \"{}\" does not exist", entry.getKey());
                continue;
            }
            entryTag.m_128359_("Item", itemId.toString());
            entryTag.m_128365_("Value", (Tag)serializer.apply(entry.getValue()));
            mapTag.add((Object)entryTag);
        }
        tag.m_128365_(key, (Tag)mapTag);
        return tag;
    }

    public static <T> Map<Item, T> deserializeItemMap(CompoundTag tag, String key, Function<CompoundTag, T> deserializer) {
        HashMap<Item, T> map = new HashMap<Item, T>();
        CompoundTag mapTag = tag.m_128469_(key);
        for (String itemID : mapTag.m_128431_()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemID));
            T value = deserializer.apply(mapTag.m_128469_(itemID));
            if (value == null) continue;
            map.put(item, value);
        }
        return map;
    }

    public static <T> Multimap<Item, T> deserializeItemMultimap(CompoundTag tag, String key, Function<CompoundTag, T> deserializer) {
        FastMultiMap map = new FastMultiMap();
        ListTag mapTag = tag.m_128437_(key, 10);
        for (int i = 0; i < mapTag.size(); ++i) {
            CompoundTag entryTag = mapTag.m_128728_(i);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entryTag.m_128461_("Item")));
            T value = deserializer.apply(entryTag.m_128469_("Value"));
            if (value == null) continue;
            map.put(item, value);
        }
        return map;
    }

    public static <T> Map<Item, T> readItemMap(List<? extends List<?>> source, BiFunction<Item, List<?>, T> valueParser) {
        return (Map)ConfigHelper.readItemMapLike(source, valueParser).getFirst();
    }

    public static <T> Multimap<Item, T> readItemMultimap(List<? extends List<?>> source, BiFunction<Item, List<?>, T> valueParser) {
        return (Multimap)ConfigHelper.readItemMapLike(source, valueParser).getSecond();
    }

    private static <T> Pair<Map<Item, T>, Multimap<Item, T>> readItemMapLike(List<? extends List<?>> source, BiFunction<Item, List<?>, T> valueParser) {
        HashMap<Item, T> map = new HashMap<Item, T>();
        FastMultiMap multimap = new FastMultiMap();
        for (List<?> entry : source) {
            String itemId = (String)entry.get(0);
            for (Item item : ConfigHelper.getItems(itemId)) {
                T value = valueParser.apply(item, entry.subList(1, entry.size()));
                if (value == null) continue;
                map.put(item, value);
                multimap.put(item, value);
            }
        }
        return Pair.of(map, multimap);
    }

    public static <T> void writeItemMap(Map<Item, T> map, Consumer<List<? extends List<?>>> saver, Function<T, List<?>> valueWriter) {
        ConfigHelper.writeItemMapLike(Either.left(map), saver, valueWriter);
    }

    public static <T> void writeItemMultimap(Multimap<Item, T> map, Consumer<List<? extends List<?>>> saver, Function<T, List<?>> valueWriter) {
        ConfigHelper.writeItemMapLike(Either.right(map), saver, valueWriter);
    }

    private static <T> void writeItemMapLike(Either<Map<Item, T>, Multimap<Item, T>> map, Consumer<List<? extends List<?>>> saver, Function<T, List<?>> valueWriter) {
        ArrayList list = new ArrayList();
        for (Map.Entry entry : (Collection)map.map(Map::entrySet, Multimap::entries)) {
            Item item = (Item)entry.getKey();
            Object value = entry.getValue();
            ArrayList<String> itemData = new ArrayList<String>();
            ResourceLocation itemID = ForgeRegistries.ITEMS.getKey((Object)item);
            if (itemID == null) {
                ColdSweat.LOGGER.error("Error writing item map: item \"{}\" does not exist", (Object)item);
                continue;
            }
            itemData.add(itemID.toString());
            List<?> args = valueWriter.apply(value);
            if (args == null) continue;
            itemData.addAll(args);
            list.add(itemData);
        }
        saver.accept(list);
    }

    public static CompoundTag serializeItemInsulations(Multimap<Item, Insulator> map, String key) {
        CompoundTag tag = new CompoundTag();
        ListTag mapTag = new ListTag();
        for (Map.Entry entry : map.entries()) {
            Item item = (Item)entry.getKey();
            Insulator insulator = (Insulator)entry.getValue();
            ResourceLocation itemID = ForgeRegistries.ITEMS.getKey((Object)item);
            if (itemID == null) {
                ColdSweat.LOGGER.error("Error serializing item insulations: item \"{}\" does not exist", (Object)item);
                continue;
            }
            if (insulator == null) {
                ColdSweat.LOGGER.error("Error serializing item insulations: insulation value for item \"{}\" is null", (Object)item);
                continue;
            }
            CompoundTag insulatorTag = new CompoundTag();
            insulatorTag.m_128365_("Insulator", (Tag)insulator.serialize());
            insulatorTag.m_128359_("Item", itemID.toString());
            mapTag.add((Object)insulatorTag);
        }
        tag.m_128365_(key, (Tag)mapTag);
        return tag;
    }

    public static Multimap<Item, Insulator> deserializeItemInsulations(CompoundTag tag, String key) {
        FastMultiMap<Item, Insulator> map = new FastMultiMap<Item, Insulator>();
        ListTag mapTag = tag.m_128437_(key, 10);
        for (int i = 0; i < mapTag.size(); ++i) {
            CompoundTag insulatorTag = mapTag.m_128728_(i);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(insulatorTag.m_128461_("Item")));
            Insulator insulator = Insulator.deserialize(insulatorTag.m_128469_("Insulator"));
            if (item == null || insulator == null) continue;
            map.put(item, insulator);
        }
        return map;
    }

    public static Multimap<Item, Insulator> readItemInsulations(List<? extends List<?>> items, Insulation.Slot slot) {
        return ConfigHelper.readItemMultimap(items, (item, args) -> {
            if (args.size() < 2) {
                ColdSweat.LOGGER.error(new ArgumentCountException(args.size(), 2, String.format("Error parsing insulation config for item %s", item)).getMessage());
                return null;
            }
            double value1 = ((Number)args.get(0)).doubleValue();
            double value2 = ((Number)args.get(1)).doubleValue();
            String type = args.size() > 2 ? (String)args.get(2) : "static";
            CompoundTag nbt = args.size() > 3 ? NBTHelper.parseCompoundNbt((String)args.get(3)) : new CompoundTag();
            Insulation insulation = type.equals("static") ? new StaticInsulation(value1, value2) : new AdaptiveInsulation(value1, value2);
            ItemRequirement requirement = new ItemRequirement(Optional.of(List.of(Either.right((Object)item))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), new NbtRequirement(nbt));
            return new Insulator(insulation, slot, requirement, EntityRequirement.NONE, new AttributeModifierMap(), new HashMap<ResourceLocation, Double>());
        });
    }

    public static void writeItemInsulations(Multimap<Item, Insulator> items, Consumer<List<? extends List<?>>> saver) {
        ConfigHelper.writeItemMultimap(items, saver, insulator -> {
            if (insulator == null) {
                ColdSweat.LOGGER.error("Error writing item insulations: insulator value is null");
                return List.of();
            }
            if (!insulator.predicate().equals(EntityRequirement.NONE) || !insulator.attributes().getMap().isEmpty()) {
                return List.of();
            }
            ArrayList<Object> itemData = new ArrayList<Object>();
            itemData.add(insulator.insulation() instanceof StaticInsulation ? insulator.insulation().getCold() : ((AdaptiveInsulation)insulator.insulation()).getInsulation());
            itemData.add(insulator.insulation() instanceof StaticInsulation ? insulator.insulation().getHeat() : ((AdaptiveInsulation)insulator.insulation()).getSpeed());
            itemData.add(insulator.insulation() instanceof StaticInsulation ? "static" : "adaptive");
            itemData.add(insulator.data().nbt().serialize().toString());
            return itemData;
        });
    }

    public static <T> Codec<Either<TagKey<T>, T>> tagOrForgeRegistryCodec(ResourceKey<Registry<T>> vanillaRegistry, IForgeRegistry<T> forgeRegistry) {
        return Codec.either((Codec)Codec.STRING.comapFlatMap(str -> {
            if (!str.startsWith("#")) {
                return DataResult.error((String)("Not a tag key: " + str));
            }
            ResourceLocation itemLocation = new ResourceLocation(str.replace("#", ""));
            return DataResult.success((Object)TagKey.m_203882_((ResourceKey)vanillaRegistry, (ResourceLocation)itemLocation));
        }, key -> "#" + key.f_203868_()), (Codec)forgeRegistry.getCodec());
    }

    public static <T> Codec<Either<TagKey<T>, T>> tagOrVanillaRegistryCodec(ResourceKey<Registry<T>> vanillaRegistry, Codec<Holder<T>> codec) {
        return Codec.either((Codec)Codec.STRING.comapFlatMap(str -> {
            if (!str.startsWith("#")) {
                return DataResult.error((String)("Not a tag key: " + str));
            }
            ResourceLocation itemLocation = new ResourceLocation(str.replace("#", ""));
            return DataResult.success((Object)TagKey.m_203882_((ResourceKey)vanillaRegistry, (ResourceLocation)itemLocation));
        }, key -> "#" + key.f_203868_()), (Codec)codec.xmap(Holder::m_203334_, Holder::m_205709_));
    }

    public static <T> Codec<Either<TagKey<T>, ResourceKey<T>>> tagOrResourceKeyCodec(ResourceKey<Registry<T>> vanillaRegistry) {
        return Codec.either((Codec)Codec.STRING.comapFlatMap(str -> {
            if (!str.startsWith("#")) {
                return DataResult.error((String)("Not a tag key: " + str));
            }
            ResourceLocation itemLocation = new ResourceLocation(str.replace("#", ""));
            return DataResult.success((Object)TagKey.m_203882_((ResourceKey)vanillaRegistry, (ResourceLocation)itemLocation));
        }, key -> "#" + key.f_203868_()), (Codec)ResourceKey.m_195966_(vanillaRegistry));
    }

    public static <T> String serializeTagOrResourceKey(Either<TagKey<T>, ResourceKey<T>> obj) {
        return (String)obj.map(tag -> "#" + tag.f_203868_(), key -> key.m_135782_().toString());
    }

    public static <T> String serializeTagOrRegistryObject(IForgeRegistry<T> forgeRegistry, Either<TagKey<T>, T> obj) {
        return (String)obj.map(tag -> "#" + tag.f_203868_(), regObj -> forgeRegistry.getKey(regObj).toString());
    }

    public static <T> Either<TagKey<T>, ResourceKey<T>> deserializeTagOrResourceKey(ResourceKey<Registry<T>> registry, String key) {
        if (key.startsWith("#")) {
            ResourceLocation tagID = new ResourceLocation(key.replace("#", ""));
            return Either.left((Object)TagKey.m_203882_(registry, (ResourceLocation)tagID));
        }
        ResourceKey biomeKey = ResourceKey.m_135785_(registry, (ResourceLocation)new ResourceLocation(key));
        return Either.right((Object)biomeKey);
    }

    public static <T> Either<TagKey<T>, T> deserializeTagOrRegistryObject(String tagOrRegistryObject, ResourceKey<Registry<T>> vanillaRegistry, IForgeRegistry<T> forgeRegistry) {
        if (tagOrRegistryObject.startsWith("#")) {
            ResourceLocation tagID = new ResourceLocation(tagOrRegistryObject.replace("#", ""));
            return Either.left((Object)TagKey.m_203882_(vanillaRegistry, (ResourceLocation)tagID));
        }
        ResourceLocation id = new ResourceLocation(tagOrRegistryObject);
        Object obj = forgeRegistry.getValue(id);
        if (obj == null) {
            ColdSweat.LOGGER.error("Error deserializing config: object \"{}\" does not exist", (Object)tagOrRegistryObject);
            return null;
        }
        return Either.right((Object)obj);
    }

    public static Optional<PredicateItem> findFirstItemMatching(DynamicHolder<Multimap<Item, PredicateItem>> predicates, ItemStack stack) {
        for (PredicateItem predicate : predicates.get().get((Object)stack.m_41720_())) {
            if (!predicate.test(stack)) continue;
            return Optional.of(predicate);
        }
        return Optional.empty();
    }

    public static <T> Optional<T> parseResource(ResourceManager resourceManager, ResourceLocation location, Codec<T> codec) {
        Optional optional;
        if (resourceManager == null) {
            return Optional.empty();
        }
        Resource resource = (Resource)resourceManager.m_213713_(location).orElseThrow();
        InputStreamReader reader = new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8);
        try {
            JsonObject json = GsonHelper.m_13859_((Reader)reader);
            optional = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load JSON file: " + location, e);
            }
        }
        ((Reader)reader).close();
        return optional;
    }
}

